    subroutine trini(ulog,uini,dg2rad)
! reads initialization file, R.L. Baum, USGS, revised by H.X. Chen, 2014
	use input_file_defs; use input_vars
	implicit none
	integer:: i,j,iz,linct
	integer, intent(in):: ulog,uini
	double precision, intent(in):: dg2rad
	character (len=31):: scratch
	
	init='edda_in.txt'
	inquire (file=trim(init),exist=ans)
	if (ans) then
	  open (uini,file=trim(init),status='old',err=201)
	  write (*,*) 'Opening default initialization file'
	else
	  write (*,*) 'Cannot locate default initialization file, <edda_in.txt>'
	  write (*,*) 'Type name of initialization file and'
	  write (*,*) 'press RETURN to continue'
	  read (*,'(a)') init
	  open (uini,file=trim(init),status='old',err=201)
	end if
	write (ulog,*) 'initialization file -->',init
	write (ulog,*) '-- LISTING OF INITIALIZATION FILE --'	
! write copy of data to log file
	linct=1	
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) title; linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) title
  	write (*,*) title
  	read (uini,'(a)',err=420) heading; linct=linct+1
  	read (uini,*,err=420) imax,row,col,nwf,tx,nmax,aif; linct=linct+1
  	write (ulog,*) heading
  	if(nmax<2) nmax=2 ! set minimum value for nmax
  	write (ulog,*) imax,row,col,nwf,tx,nmax,aif
  	
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) nzsb,nzst,mmax,nper,zmin,uww,t,nzon; linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) nzsb,nzst,mmax,nper,zmin,uww,t,nzon
  	read (uini,'(a)',err=420) heading; linct=linct+1
    read (uini,*,err=420) cltstar,clbstar,czmax,dep,crizero,slomin; linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) cltstar,clbstar,czmax,dep,crizero,slomin
  	slomin=slomin*dg2rad ! convert minimum slope angle to radians
 	read (uini,'(a)',err=420) heading; linct=linct+1
    read (uini,*,err=420) nsection; linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) nsection
! allocate & read arrays for zone properties and initial conditions  	
  	allocate (cb(nzon),sdcb(nzon),ct(nzon),sdct(nzon),phib(nzon),sdphib(nzon),phit(nzon),sdphit(nzon),phibb(nzon),sdphibb(nzon),phibt(nzon),sdphibt(nzon),uwsb(nzon),uwst(nzon),difb(nzon),dift(nzon),&
	  & ksb(nzon),kst(nzon),thsatb(nzon),thsatt(nzon),thresib(nzon),thresit(nzon),thinib(nzon),thinit(nzon),porob(nzon),porot(nzon),psib(nzon),psit(nzon),alphab(nzon),alphat(nzon),unsat(nzon),kero(nzon))
	cb=0.;ct=0.;phib=0.;phit=0.;phibb=0.;phibt=0.;
	sdcb=0.;sdct=0.;sdphib=0.;sdphit=0.;sdphibb=0.;sdphibt=0.;
	uwsb=0.;uwst=0.;difb=0.;dift=0.;ksb=0.;kst=0.;thsatb=0.;thsatt=0.;thresib=0.;thresit=0.;psib=0.;psit=0.;alphab=0.;alphat=0.
	kero=0.
	unsat=.true.;unsat0=.false.
  	do i=1,nzon
  	  read (uini,*,err=420) scratch,iz ! property zone number
  	  linct=linct+1
  	  ! read properties of the bottom layer
  	  read (uini,'(a)',err=420) heading; linct=linct+1
	  read (uini,*,err=420) cb(iz),sdcb(iz),phib(iz),sdphib(iz),phibb(iz),sdphibb(iz),&
	  & uwsb(iz),difb(iz),ksb(iz),thsatb(iz),thresib(iz),thinib(iz),porob(iz),psib(iz),alphab(iz) ! zone parameters
	  linct=linct+1
  	  write (ulog,*) trim(scratch),': ',iz
  	  write (ulog,*) heading
  	  write (ulog,*) cb(iz),sdcb(iz),phib(iz),sdphib(iz),phibb(iz),sdphibb(iz),&
	  & uwsb(iz),difb(iz),ksb(iz),thsatb(iz),thresib(iz),thinib(iz),porob(iz),psib(iz),alphab(iz)
	  ! read properties of the top layer
  	  read (uini,'(a)',err=420) heading; linct=linct+1
	  read (uini,*,err=420) ct(iz),sdct(iz),phit(iz),sdphit(iz),phibt(iz),sdphibt(iz),&
	  & uwst(iz),dift(iz),kst(iz),thsatt(iz),thresit(iz),thinit(iz),porot(iz),psit(iz),alphat(iz),kero(iz) ! zone parameters
	  linct=linct+1
	  write (ulog,*) heading
  	  write (ulog,*) ct(iz),sdct(iz),phit(iz),sdphit(iz),phibt(iz),sdphibt(iz),&
	  & uwst(iz),dift(iz),kst(iz),thsatt(iz),thresit(iz),thinit(iz),porot(iz),psit(iz),alphat(iz),kero(iz) 
	  
	  if(thsatb(iz)<thresib(iz) .or.thsatt(iz)<thresit(iz) ) then 
	    write(*,*)'Error, Theta-resid. > Theta-sat. for property zone',iz
	    write(*,*)'Saturated infiltration model will be used for cells in zone', iz,'.'
	    write(ulog,*)'Error, Theta-resid. > Theta-sat. for property zone',iz
	    write(ulog,*)'Saturated infiltration model will be used for cells in zone', iz,'.'
	    unsat(iz)=.false.
	  end if
	  if(alphab(iz)<=0 .or. alphat(iz)<=0) then
	    write(*,*)'Negative or zero value of Alpha for property zone',iz
	    write(*,*)'Saturated infiltration model will be used for cells in zone', iz,'.'
	    write(ulog,*)'Negative or zero value of Alpha for property zone',iz
	    write(ulog,*)'Saturated infiltration model will be used for cells in zone', iz,'.'
	    unsat(iz)=.false.
	  end if
	  if(unsat(iz)) then
	    unsat0=.true. ! tracks whether any property zones are unsat.
	    write(*,*)'Unsaturated infiltration model will be used for cells in zone', iz,'.'
	    write(ulog,*)'Unsaturated infiltration model will be used for cells in zone', iz,'.'
	  end if
  	end do
  	phib=phib*dg2rad;  	phit=phit*dg2rad; phibb=phibb*dg2rad; phibt=phibt*dg2rad 
  	sdphib=sdphib*dg2rad; sdphit=sdphit*dg2rad;sdphibb=sdphibb*dg2rad;sdphibt=sdphibt*dg2rad ! convert phi angles to radians
! Allocate & read arrays for storm period data	
	allocate (cri(nper),capt(nper+2),rifil(nper)) 
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) (cri(j), j=1,nper) ! List of rainfall rates
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) (cri(j), j=1,nper)
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) (capt(j), j=1,nper+1) ! List of times corresponding to change of rate
	capt(nper+2)=t ! for cases where t>capt(nper+1)
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) (capt(j), j=1,nper+1)
!  path names of input files
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) slofil ! File name of slope angle grid (slofil)
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) slofil

  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) demfil ! File name of dem grid (demfil)
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) demfil
  	
	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) manningfil ! File name of manning coefficients (manningfil)
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) manningfil
  	
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) dirfil ! File name of flow direction grid (dirfil)
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) dirfil

  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) zonfil ! File name of property zone grid (zonfil)
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) zonfil
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) ltstarfil ! File name of erodible layer grid (zfil)
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) ltstarfil
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) depfil ! File name of initial depth of water table grid (depfil)
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) depfil
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) rizerofil ! File name of initial infiltration rate grid (rizerofil)
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) rizerofil
  	!read road map file
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) roadfil ! File name of road grid (roadfil)
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) roadfil
  	!read catchment file
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) catchmentfil ! File name of catchment grid (catchmentfil)
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) catchmentfil
  	!read mouthpoint file
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) mouthpointfil ! File name of mouthpoint grid (mouthpointfil)
	linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) mouthpointfil
  	
  	read (uini,'(a)',err=420) heading; linct=linct+1
  	write (ulog,*) heading
  
    do j=1,nper
      read (uini,'(a)',err=421) rifil(j) ! List of file names of rainfall intensity for each period, (rifil())
      linct=linct+1	
      write (ulog,*) rifil(j)
    end do
  	
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) nxtfil ! File name of grid of D8 runoff receptor cell numbers (nxtfil)
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) nxtfil
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) ndxfil ! File name of list of defining runoff computation order (ndxfil)
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) ndxfil
  	read (uini,'(a)',err=420) heading; linct=linct+1
	  linct=linct+1	
	read (uini,'(a)',err=420) dscfil ! File name of list of all runoff receptor cells  (dscfil)
  	write (ulog,*) heading
  	write (ulog,*) dscfil
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) wffil ! File name of list of runoff weighting factors  (wffil)
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) wffil  	    
 	
!  location of output files	
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) folder ! Folder where output grid files will be stored  (folder)
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) folder
!  output-file ID code
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,'(a)',err=420) suffix ! Identification code to be added to names of output files (suffix)
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) suffix
!  output file selections	
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) rodoc ! Save grid files of runoff?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) rodoc
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) outp(3) ! Save grid of minimum factor of safety?
  	write (ulog,*) heading
  	write (ulog,*) outp(3)
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) outp(4) ! Save grid of depth of minimum factor of safety?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) outp(4)
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) outp(5) ! Save grid of pore pressure at depth of minimum factor of safety?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) outp(5)
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) outp(6) ! Save grid files of actual infiltration rate?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) outp(6)
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) outp(7) ! Save grid files of unsaturated zone basal flux?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) outp(7)
  	! save the deposit distribution
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) depositsave ! Save grid files of the deposit distribution?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) depositsave
  	
  	  ! save the probability of failure (pf)
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) pfsave ! Save grid of probability of failure (pf) at depth of minimum factor of safety?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) pfsave
  	 ! save the risk
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) risksave ! Save grid of risk imposed by the slope failure to the road?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) risksave
  	
  	! save the warning level
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) warninglevelsave ! Save grid of warning level along the road?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) warninglevelsave
  	 ! save the trace of detached material or debris
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) tracesave ! Save grid of trace of the detached material and debris?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) tracesave
  	
  	
  	read (uini,'(a)',err=420) heading; linct=linct+1
  	read (uini,*,err=420) flag ! Save listing of pressure head and factor of safety ("flag")?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) flag
  	
  	read (uini,'(a)',err=420) heading; linct=linct+1
  	read (uini,*,err=420) nout ! Number of times to save output grids of slope failures
	  linct=linct+1	
  	if(nout<1) nout=1 ! must save at least one time; negative number not allowed
  	write (ulog,*) heading
  	write (ulog,*) nout 
  	allocate (tsav(nout),ksav(nout))
  	tsav=0.;ksav=0
  	read (uini,'(a)',err=420) heading; linct=linct+1 
  	read (uini,*,err=420) (tsav(j), j=1,nout) ! Times of output grids
	  linct=linct+1	
	do j=1,nout
	if (tsav(j)>t) tsav(j)=t
	end do
  	write (ulog,*) heading
  	write (ulog,*) (tsav(j), j=1,nout)
  	
! user options  	
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) lskip ! Skip other timesteps?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) lskip
  	
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) lany ! Use analytic solution for fillable porosity?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) lany
  	
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) llus ! Estimate positive pressure head in rising water table zone
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) llus
  	
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) lps0 ! Use psi0=-1/alpha?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) lps0
  	
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) outp(8) ! Log mass balance results?
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) outp(8)
  	
 	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) flowdir ! Specify flow direction
      linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) flowdir
  	
! added 19 Aug 2009 RLB-------------------
 	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) bkgrof; linct=linct+1 ! Specify background flux offset 
  	write (ulog,*) heading
  	write (ulog,*) bkgrof
  	
  	! read information for debris flow simulation
  	read (uini,'(a)',err=420) heading; linct=linct+1
  	write (ulog,*) heading
  	! reading flow resistance parameters
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) alpha1,beta1,alpha2,beta2,kresis,cmanning,limitfr,shallown; linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) alpha1,beta1,alpha2,beta2,kresis,cmanning,limitfr,shallown	
  	
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) d50,cvstar,coedepo,cs; linct=linct+1 ! 
  	write (ulog,*) heading
  	write (ulog,*)  d50,cvstar,coedepo,cs
  	
  	! read parameters for variable time steps
  	! dtmin is the minmum allowable timestep in second
  	! dtmax is the maximum allowable timestep in second
  	! dti is the increment of tiemstep in second
  	! dtd is the decrement of timestep in second
  	! simul is the total simulation time in hour for debris flow
  	! tol is the tolerant change of flow depth
  	! toldhp is the tolerant percentage of the change of the flow depth
   	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) dtmin,dtmax,dti,dtd,simul,tout,toldh,toldhp,wavemax; linct=linct+1
  	write (ulog,*) heading
  	write (ulog,*) dtmin,dtmax,dti,dtd,simul,tout,toldh,toldhp,wavemax
  	
  	! read the option to use the full dynamic wave equation
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) fulldyna 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) fulldyna
  	
  	! read the option to simulate rainfall
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) rainsimul 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) rainsimul
  	
  	! read the option to simulate infiltration
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) infilsimul 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) infilsimul
  	
  	! read the option to simulate inflow hydrograph
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) inflowsimul 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) inflowsimul
  	
  	! read the option to simulate outflow cell
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) outflowsimul 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) outflowsimul
  	
  	! read the option to simulate shallow landslide
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) fssimul 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) fssimul
  	
  	! read the option to simulate debris flow
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) debrissimul 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) debrissimul
  	
  	! read the option to simulate erosion
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) erosionsimul 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) erosionsimul
  	
  	! read the option to simulate the water and solid material seperately
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) sepdepositionsimul
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) sepdepositionsimul
  	
    ! read the option to save minimum factor of safety
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) fsminsave
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) fsminsave
  	 	
    ! read the option to save flow depth
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) flowdepthsave 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) flowdepthsave

     ! read the option to save maximum flow depth
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) maxflowdepthsave 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) maxflowdepthsave
  	
  	! read the option to save flow velocity
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) fvsave 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) fvsave
  	
  	! read the option to save maxmimum flow velocity
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) maxfvsave 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) maxfvsave
  	
  	! read the option to save the erosion depth
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) erodepthsave 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) erodepthsave
  	
   ! read the option to save the deposition depth when simulating the water and soil deposition seperately
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) debdepodepthsave 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) debdepodepthsave
  	
   ! read the option to save the total depth of flow depth and deposit depth
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) totaldepthsave 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) totaldepthsave
  	
  ! read the option to save the volumetric sediment concentration
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) cvsave 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) cvsave
  	
  ! read the option to save the outflow hydrograph
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) outflowsave 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) outflowsave
  	
    ! read the option to save the hydrograph of specified celss
  	read (uini,'(a)',err=420) heading; linct=linct+1
	read (uini,*,err=420) hydrosave 
	  linct=linct+1	
  	write (ulog,*) heading
  	write (ulog,*) hydrosave
  	
!-----------------------------------------  	
	close(uini)
	write (ulog,*) '-- END OF INITIALIZATION DATA --'	
	write (ulog,*) ''
	write (ulog,*) title
	write (ulog,*) ''
  	do iz=1,nzon
	  if(alphab(iz)>=0 .and. unsat(iz)) then
	    write(*,*) '******** Zone ',iz, ' *********'
	    write(*,*)'Using unsaturated infiltration model.'
	    write(*,*) 'Cells where water table is shallower than '
	    write(*,*) '           ', 1./alphab(iz)
	    write(*,*) 'treated as tension saturated--Saturated infiltration model used.'
	    write(ulog,*) '******** Zone ',iz, ' *********'
	    write(ulog,*)'Using unsaturated infiltration model.'
	    write(ulog,*) 'Cells where water table is shallower than '
	    write(ulog,*) '           ', 1./alphab(iz)
	    write(ulog,*) 'treated as tension saturated--Saturated infiltration model used.'
	  end if
	end do
	return
  201	continue
	write (*,*) '*** Error opening intialization file *** 201'
	write (*,*) '--> ',trim(init)
	write (*,*) 'Check file location and name'
    write (ulog,*) '*** Error opening intialization file ***'
    write (ulog,*) '--> ',trim(init)
    write (ulog,*) 'Check file location and name'
	pause 'Press RETURN to exit'
	stop '201'
  420	continue
  	write (*,*) 'Error reading initialization file 420'
	write (*,*) '--> ',trim(init), ' at line ',linct
	write (*,*) 'Check file contents and organization'
  	write (ulog,*) 'Error reading initialization file'
	write (ulog,*) '--> ',trim(init), ' at line ',linct
	write (ulog,*) 'Check file contents and organization'
	pause 'Press RETURN to exit'
	stop '420'
  421	continue
  	write (*,*) 'Error reading initialization file 421'
	write (*,*) '--> ',trim(init), ' at line ',linct
	write (*,*) 'Check file contents and organization'
	write (*,*) 'Number of file names/place holders for rainfall data'
	write (*,*) 'must equal nper.  List each on a separate line.'
  	write (ulog,*) 'Error reading initialization file'
	write (ulog,*) '--> ',trim(init), ' at line ',linct
	write (ulog,*) 'Check file contents and organization'
	write (ulog,*) 'Number of file names/place holders for rainfall data'
	write (ulog,*) 'must equal nper.  List each on a separate line.'
	pause 'Press RETURN to exit'
	stop '421'
	end subroutine trini